#include <iostream>
#include <iomanip>
using namespace std;

void heapify(double arr[], int n, int i, int arr2[])
{
    int naj = i;
    int l = 2 * i + 1;
    int r = 2 * i + 2;

    if (l < n && arr[l] > arr[naj])
        naj = l;

    if (r < n && arr[r] > arr[naj])
        naj = r;

    if (naj != i) {
        swap(arr[i], arr[naj]);
        swap(arr2[i], arr2[naj]);
        heapify(arr, n, naj, arr2);
    }
}

void hSort(double arr[], int n, int arr2[])
{
    for (int i = n / 2 - 1; i >= 0; i--)
        heapify(arr, n, i, arr2);

    for (int i = n - 1; i > 0; i--) {
        swap(arr[0], arr[i]);
        swap(arr2[0], arr2[i]);
        heapify(arr, i, 0, arr2);
    }
}

int main()
{
    int n;
    cin>>n;
    int zarada[n];
    double maxporez[n];
    for(int i = 0; i < n; i++){
        cin>>zarada[i]>>maxporez[i];
    }
    hSort(maxporez,n,zarada);

    double konzarada = 0;
    for(int i = 0; i < n; i++){
        double pom = 0;
        for(int j = n-1; j >= i; j--)
            pom += zarada[j]*maxporez[i]/100;
        if(pom > konzarada)
            konzarada = pom;
    }
    cout << std::fixed;
    cout << std::setprecision(4);
    cout<<konzarada;
    return 0;
}